<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* EapType File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Beta\Microsoft\Graph\Model;

use Microsoft\Graph\Core\Enum;

/**
* EapType class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class EapType extends Enum
{
    /**
    * The Enum EapType
    */
    const EAP_TLS = "eapTls";
    const LEAP = "leap";
    const EAP_SIM = "eapSim";
    const EAP_TTLS = "eapTtls";
    const PEAP = "peap";
    const EAP_FAST = "eapFast";
    const TEAP = "teap";
}
